<?php

namespace ColemanProjects\Taxi\Validator;

use Laminas\Validator\AbstractValidator;

class IntegerGreaterThan extends AbstractValidator
{
    public const MSG_NUMERIC = 'msgNumeric';
    public const MSG_MINIMUM_VALUE = 'msgMinValue';

    public $minimum_value;

    protected $messageVariables = [
        'min' => 'minimum_value'
    ];

    protected $messageTemplates = [
        self::MSG_NUMERIC => "'%value%' must be an integer",
        self::MSG_MINIMUM_VALUE => "'%value%' must be at least '%min%'",
    ];

    public function __construct($options)
    {
        parent::__construct($options);

        $this->minimum_value = $options['min'];
    }

    public function isValid($value)
    {
        $this->setValue($value);

        if (filter_var($value, FILTER_VALIDATE_INT) === false) {
            $this->error(self::MSG_NUMERIC);
            return false;
        }

        if ($value < $this->minimum_value) {
            $this->error(self::MSG_MINIMUM_VALUE);
            return false;
        }

        return true;
    }
}
